'This code simulates an Oregon Scientific temperature sensor, type THGR810
'This sensor measures temperature and humidity and trasnmits the data to an Oregon Base using
'433.92 Mhz
'The data is sent in 4 bit nibbles using normal Manchester coding.
'The data rate is 1024 Hz which equals Oregon V3 protocol. 1/2 bit time = 488 uS
'The RF message data layout is as follows.
'A preamble of 6 nibbles consisting of all 1.
'A sync nibble of 10.
'Sensor data follows.


'Sensor data is as follows.
'Sensor ID - 4 nibbles, oregon THGR810 has ID of F824
'Sensor rolling code  - 1 nibble
'Sensor battery flag  - 1 nibble
'Sensor temperature  - 3 nibbles format is xx.x deg
'Sensor temperature sign - 1 nibble 0 is positive , non zero is negative.
'Sensor humidity - 2 nibbles = xx%
'1 nibble next of which purpose is unknown.****
'Sensor CRC which is simply arithmetical sum of data from Sensor data to above data ****
'Sensor post amble - 2 nibbles purpose unknown.
'Nibbles are sent in order with the LSB of each nibble sent first.
'Sensor code for THGR810 sensor is F824.
'Transmit data port is PORTA.6 on 16F88.

'Notes on the DHT22 temp Sensor.
'This Sensor sends 5 bytes of data which are RH1-RH2, Temp1-Temp2, crc
'Rh1-Rh2 is a 16 bit word that is divided by 10 to read XX.X %
'Temp1-Temp2 is a 16 bit word that is divided by 10 to read XX.X D
'If the MSB of Temp1 is 1 , the temp is -, ie below 0D C.
'The CRC is the 8 bit sum the 4 data bytes.


AllDigital
OSCCON.IRCF2 = 1  'Configure PIC for 4 Mhz , Internal Oscillator
OSCCON.IRCF1 = 1
OSCCON.IRCF0 = 0
Define CLOCK_FREQUENCY = 4
WDTCON.WDTPS3 = 1  'Set WDT prescaler to 65536, gives WDT of 2.3 seconds
WDTCON.WDTPS2 = 0
WDTCON.WDTPS1 = 1
WDTCON.WDTPS0 = 1
WDTCON.SWDTEN = 1  'enable WDT

OPTION_REG.PSA = 1  'Assign TMR0 prescaler to WDT
OPTION_REG.PS2 = 1  'Set WDT prescaler to 32, gives WDT timeout of 73 swconds.
OPTION_REG.PS1 = 0
OPTION_REG.PS0 = 1
OPTION_REG.T0CS = 0  'enable tmr0
CMCON.CM2 = 1  'Turn off Comparators to reduce power consumption when sleeping.
CMCON.CM1 = 1  '-
CMCON.CM0 = 1  '-







'Define SIMULATION_WAITMS_VALUE = 1, only used for IDE
Dim x1 As Byte
Dim x2 As Byte
Dim flags As Byte
Dim syncflag As Byte
Dim channel As Byte
Dim rollingcode1 As Byte
Dim rollingcode2 As Byte
Dim battflag As Byte
Dim temp1 As Byte
Dim temp2 As Byte
Dim temp3 As Byte
Dim tempsign As Byte
Dim humidity1 As Byte
Dim humidity2 As Byte
Dim humidity3 As Byte
Dim sensorid1 As Byte
Dim sensorid2 As Byte
Dim sensorid3 As Byte
Dim sensorid4 As Byte
Dim unknown As Byte
Dim crc As Byte
Dim crc1 As Byte
Dim crc2 As Byte
Dim hum As Word
Dim tmp As Word
Dim packetbit As Byte





Dim packet As Byte
Dim tpacket(5) As Byte
Dim n As Byte
Dim chksm As Byte


TRISA = 0  'port as output
TRISB = 0  'port as output
PORTA = 0
TRISB.3 = 1  'pin as input



flags = 15  '4 bit nibble with all 1s
syncflag = 10  'sync
sensorid1 = 0xf  'nibble 0
sensorid2 = 0x8  'nibble 1
sensorid3 = 0x2  'nibble 2
sensorid4 = 0x4  'nibble 3
channel = 7  'nibble 4 (THGR810 can use channels 1 to 10, but 1 is normally reserved by outside temp sensor.)
rollingcode1 = 0x8  'nibble 5
rollingcode2 = 0x5  'nibble 6

battflag = 0  'nibble 7
temp1 = 4  'nibble 8 'Temp=21.4
temp2 = 1  'nibble 9
temp3 = 2  'nibble 10
tempsign = 0  'nibble 11 0 for positive value, non zero for negative value
humidity1 = 2  'nibble 12 28%
humidity2 = 8  'nibble 13
humidity3 = 0  'Not used in this version.
unknown = 0  'nibble 14 not known what this data is for.

TRISB.0 = 0
For x1 = 1 To 10  'Flash the led to indicate we have started.
	WaitMs 500
	PORTB.0 = 1
	WaitMs 500
	PORTB.0 = 0
Next x1




start:  'Main Loop.
ASM:        sleep  'this puts the CPU in low power mode for 73 seconds
'We wake up here when WDT expires and run the program.
TRISB.3 = 0  'portb o/p
PORTB.3 = 1  'make high
WaitMs 50  'wait
PORTB.3 = 0
WaitMs 20  'send 20ms low,,wait for DHT22 to respond
TRISB.3 = 1  'portb i/p
p1: If PORTB.3 = 1 Then Goto p1  'skip next 3 pulses so we get to the first bit pulse.
p2: If PORTB.3 = 0 Then Goto p2
p3: If PORTB.3 = 1 Then Goto p3

For n = 0 To 4  '5 bytes to receive
packet = 0

For packetbit = 1 To 8  '8 bits per data packet
packet = ShiftLeft(packet, 1)  'accumulate bits To make data Byte

loop: If PORTB.3 = 0 Then Goto loop  'Wait for high which is start of data bit.
TMR0 = 0  'clear timer0
loop1: If PORTB.3 = 1 Then Goto loop1  'Wait for low which = end of data bit
If TMR0 > 50 Then  'Data 1 = pulse of 70 uS, data 0 = pulse of 28 uS.
	High packet.0  'Set bit 0 of packet to 1
Else
	Low packet.0  'set bit 0 of packet to 0
Endif
Next packetbit
tpacket(n) = packet
Next n
chksm = (tpacket(0) + tpacket(1) + tpacket(2) + tpacket(3))
If tpacket(4) <> chksm Then Goto error  'last 8 bits of packet are checksum
hum.HB = tpacket(0)
hum.LB = tpacket(1)
tmp.HB = tpacket(2)
tmp.LB = tpacket(3)

If tmp.15 = 1 Then  'used to indicate negative temp
	tmp.15 = 0
	tempsign = 1
Else
	tempsign = 0
Endif



temp3 = tmp / 100  'Convert Temp readings to suit OS data format
temp2 = (tmp Mod 100) / 10
temp1 = (tmp Mod 100) Mod 10
humidity2 = hum / 100  'Convert Humidity readings to suit OS data format.
humidity1 = (hum Mod 100) / 10
humidity3 = (hum Mod 100) Mod 10
ASM:        clrwdt  'Clear Watchdog timer
WaitMs 1000
Goto transmit

error:
'we should never get here but if we do its most likely that the battery is going flat. DHT22 only works down to 3V
'we send all zeroes as data and set the battery flag.
battflag = 0xc  'set the battery flat flag.
temp1 = 0
temp2 = 0
temp3 = 0  'set all variables To 0
humidity1 = 0
humidity2 = 0


transmit:
'Transmitting Code
'Calculate the CRC

crc = sensorid1 + sensorid2 + sensorid3 + sensorid4 + channel + rollingcode1 + rollingcode2 + battflag + temp1 + temp2 + temp3
crc = crc + tempsign + humidity1 + humidity2 + unknown
crc1 = crc And 0xf  'Manchester transmitting code needs data in nibbles
crc2 = ShiftRight(crc, 4)
'The above values are taken from the document Oregon Scientific RF protocol description June 2011.



'We start transmitting here.
PORTB.0 = 1  'Light the Led
PORTA.6 = 1  'turn on tx
WaitUs 1000
PORTA.6 = 0
WaitUs 628  'wait 628 us

For x1 = 1 To 6  'Transmit flags

Call encode(flags)
Next x1

Call encode(syncflag)  'Transmit sync

Call encode(sensorid1)  'Transmit Sensor ID
Call encode(sensorid2)
Call encode(sensorid3)
Call encode(sensorid4)

Call encode(channel)  'Sensor Channel

Call encode(rollingcode1)  'sensor rolling code
Call encode(rollingcode2)

Call encode(battflag)  'Battery flag

Call encode(temp1)  'Send temperature LSB first
Call encode(temp2)
Call encode(temp3)
Call encode(tempsign)  '0=Indicates a positive temp,1= negative

Call encode(humidity1)  'send humidity. LSB first
Call encode(humidity2)
Call encode(unknown)
Call encode(crc1)  'Send CRC checksum LSB first.
Call encode(crc2)
WaitMs 1
PORTA.6 = 0  'Turn off the Transmitter
PORTB.0 = 0  'Turn off the led.
Goto start






End                                               


'This routine encodes a 4 bit nibble into Manchester format.
'Needs some work to convince WMR100 that this is a genuine OS Sensor, but works fine for Arduino Weather Shield + WSDL.
Proc encode(mydata As Byte)

For x2 = 0 To 3
	
If mydata.0 = 1 Then
	PORTA.6 = 1
	WaitUs 488
	PORTA.6 = 0
	WaitUs 488
Else
	PORTA.6 = 0
	WaitUs 488
	PORTA.6 = 1
	WaitUs 488
Endif
mydata = ShiftRight(mydata, 1)
Next x2
End Proc                                          










